.386
.model flat,stdcall
option casemap:none
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\user32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\comdlg32.lib

SEH struct
	PrevLink dd ?		; the address of the previous seh structure
	CurrentHandler dd ?	; the address of the new exception handler
	SafeOffset dd ?	; The offset where it's safe to continue execution
	PrevEsp dd ?		; the old value in esp
	PrevEbp dd ?		; The old value in ebp
SEH ends


.data
AppName db "PE tutorial no.2",0
ofn   OPENFILENAME <>
FilterString db "Executable Files (*.exe, *.dll)",0,"*.exe;*.dll",0
             db "All Files",0,"*.*",0,0
FileOpenError db "Cannot open the file for reading",0             
FileOpenMappingError db "Cannot open the file for memory mapping",0
FileMappingError db "Cannot map the file into memory",0
FileValidPE db "This file is a valid PE",0
FileInValidPE db "This file is not a valid PE",0

.data?
buffer db 512 dup(?)
hFile dd ?
hMapping dd ?
pMapping dd ?
ValidPE dd ?

.code
start proc 
LOCAL seh:SEH
	mov ofn.lStructSize,SIZEOF ofn
	mov  ofn.lpstrFilter, OFFSET FilterString
	mov  ofn.lpstrFile, OFFSET buffer
	mov  ofn.nMaxFile,512
	mov  ofn.Flags, OFN_FILEMUSTEXIST or \
                       OFN_PATHMUSTEXIST or OFN_LONGNAMES or\
                       OFN_EXPLORER or OFN_HIDEREADONLY
	invoke GetOpenFileName, ADDR ofn
	.if eax==TRUE
		invoke CreateFile, addr buffer, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hFile, eax
			invoke CreateFileMapping, hFile, NULL, PAGE_READONLY,0,0,0
			.if eax!=NULL
				mov hMapping, eax
				invoke MapViewOfFile,hMapping,FILE_MAP_READ,0,0,0
				.if eax!=NULL
					mov pMapping,eax
					assume fs:nothing
					push fs:[0]
					pop seh.PrevLink
					mov seh.CurrentHandler,offset SEHHandler
					mov seh.SafeOffset,offset FinalExit
					lea eax,seh
					mov fs:[0], eax
					mov seh.PrevEsp,esp
					mov seh.PrevEbp,ebp
					mov edi, pMapping
					assume edi:ptr IMAGE_DOS_HEADER
					.if [edi].e_magic==IMAGE_DOS_SIGNATURE
						add edi, [edi].e_lfanew
						assume edi:ptr IMAGE_NT_HEADERS
						.if [edi].Signature==IMAGE_NT_SIGNATURE
							mov ValidPE, TRUE
						.else
							mov ValidPE, FALSE
						.endif
					.else
						mov ValidPE,FALSE
					.endif
FinalExit:
					.if ValidPE==TRUE
						invoke MessageBox, 0, addr FileValidPE, addr AppName,MB_OK+MB_ICONINFORMATION
					.else
						invoke MessageBox, 0, addr FileInValidPE, addr AppName,MB_OK+MB_ICONINFORMATION
					.endif
					push seh.PrevLink
					pop fs:[0]
					invoke UnmapViewOfFile, pMapping
				.else
					invoke MessageBox, 0, addr FileMappingError, addr AppName,MB_OK+MB_ICONERROR
				.endif
				invoke CloseHandle,hMapping
			.else
				invoke MessageBox, 0, addr FileOpenMappingError, addr AppName,MB_OK+MB_ICONERROR
			.endif
			invoke CloseHandle, hFile
		.else
			invoke MessageBox, 0, addr FileOpenError, addr AppName, MB_OK+MB_ICONERROR
		.endif
	.endif	
	invoke ExitProcess, 0	
start endp	
SEHHandler proc uses edx pExcept:DWORD,pFrame:DWORD,pContext:DWORD,pDispatch:DWORD
	mov edx,pFrame		
	assume edx:ptr SEH
	mov eax,pContext
	assume eax:ptr CONTEXT
	push [edx].SafeOffset
	pop [eax].regEip
	push [edx].PrevEsp
	pop [eax].regEsp
	push [edx].PrevEbp
	pop [eax].regEbp
	mov ValidPE, FALSE
	mov eax,ExceptionContinueExecution
	ret
SEHHandler endp

end start
